/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: MibDatabase_Functionlist.h 59450 2016-02-26 14:29:30Z Benjamin $:

Description:
 MIB Database
 Includes structure definitions and prototypes to start MIB Database Server task

Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 2014-10-22    created
**************************************************************************************/
#ifndef __MIB_DATABASE_FUNCTIONLIST_H
#define __MIB_DATABASE_FUNCTIONLIST_H



/***************************************************************************************/
/* Mib Database function list, prototyes */

TLR_RESULT  TaskExit_MibDatabase (TLR_VOID FAR* pvRsc);

TLR_RESULT  TaskLeave_MibDatabase(TLR_VOID FAR* pvRsc,
                                             TLR_VOID FAR* pvLve);

TLR_RESULT  TaskEnter_MibDatabase(TLR_VOID FAR* pvInit);


typedef struct MIB_DATABASE_CUSTOM_MIB_GROUP_Ttag
{
  TLR_UINT32                  ulMibGroupId;
  struct mib_variable*        ptMibs;
  TLR_UINT32                  ulMibCount;
}
MIB_DATABASE_CUSTOM_MIB_GROUP_T;


#define MIB_DATABASE_STARTUP_PARAM_VERSION_V4 (4)

typedef struct MIB_DATABASE_STARTUPPARAMETER_V4_Ttag
{
  TLR_UINT32                        ulTaskIdentifier;
  TLR_UINT32                        ulParamVersion;
  TLR_UINT32                        ulEthPortCnt;  /* the amount of ethernet ports the device has */
  TLR_UINT32                        ulReserved;
  MIB_DATABASE_CUSTOM_MIB_GROUP_T*  ptCustomGroups;
  TLR_UINT32                        ulCustomGroupsCount;
  /* new for V4 */
  /* assume that task is running with same task instance than MIB task */
  char*                             pszQueueNameLLDP;    /* name of queue to ask for LLDP issues */
  char*                             pszQueueNameSystem;  /* name of queue to ask for system issues */
}
MIB_DATABASE_STARTUPPARAMETER_V4_T;


/***************************************************************************************/
#endif /* #ifndef __MIB_DATABASE_FUNCTIONLIST_H */
